create or replace package PKG_CABAL_CRM is

  -- Author  : OOJEDA
  -- Created : 05/07/2021 14:09:07
  -- Purpose : Almanenar las fuentes relacionadas a las funcionalidades del CRM

-- ================================================================================== --
-- Autor: Lic. Orlando Ojeda
-- Fecha: 05/07/2021
-- Proposito: Obtener el numero de CVV de un TC
-- ================================================================================== --
procedure sp_get_cvv_tarjeta(pi_tarjeta in  varchar2,
                             pi_usuario in  varchar2,
                             pi_motivo  in  varchar2,
                             po_cod_return  out varchar2,
                             po_txt_return  out varchar2,
                             po_cvv     out varchar2);

end PKG_CABAL_CRM;
/
create or replace package body PKG_CABAL_CRM is
 -- Var de Log
 v_clog_tipo_dato  varchar2(50) := 'PKG_CABAL_CRM';

-- ================================================================================== --
-- Autor: Lic. Orlando Ojeda
-- Fecha: 05/07/2021
-- Proposito: Registrar en el CEIBO_LOG un registro relacionado al CRM
-- ================================================================================== --
procedure sp_registrar_ceibo_log(PI_DESCRIPCION IN VARCHAR2,
                                 PI_DETALLE     IN VARCHAR2,
                                 PI_USUARIO     IN VARCHAR2 ) as
begin
  CREDITOPY.PKG_UTILES.PR_CEIBO_LOG(v_clog_tipo_dato,            --MAX 50
                                    SUBSTR(PI_DESCRIPCION,1,15), --MAX 15 CARACTERES (OjO)
                                    SUBSTR(PI_DETALLE,1,2048),
                                    SYSDATE,
                                    PI_USUARIO);
end;


-- ================================================================================== --
-- Autor: Lic. Orlando Ojeda
-- Fecha: 05/07/2021
-- Proposito: Obtener el numero de CVV de un TC
-- ================================================================================== --
procedure sp_get_cvv_tarjeta(pi_tarjeta in  varchar2,
                             pi_usuario in  varchar2,
                             pi_motivo  in  varchar2,
                             po_cod_return  out varchar2,
                             po_txt_return  out varchar2,
                             po_cvv     out varchar2) as
  v_cvv varchar2(100);

  -- Convierte todos los parametros de entrada del SP a una cadena de texto
  function f_i_parametros_in_toString return varchar2 as
  begin
    return 'pi_tarjeta: ' || pi_tarjeta || ';' ||
           'pi_usuario: ' || pi_usuario || ';' ||
           'pi_motivo: ' || pi_motivo || ';'
           ;
  end;


begin

  sp_registrar_ceibo_log(PI_DESCRIPCION => 'consultaCVV', -- MAX 15
                         PI_DETALLE     => 'Consulta Datos CVV. Parametros: [' || f_i_parametros_in_toString || ']',
                         PI_USUARIO     => pi_usuario);

  BEGIN PCUTILES.GET_PAN_CRIPTOKEY; END;

  select CS.GET_CVC(CEIBO_UTILES.FN_GET_EMISOR_PROCESADOR(T.EMISOR),T.TARJETA,T.FECHA_VIGENCIA,2) cvv
         into v_cvv
  from tarjetas t
  where 1=1
  and   t.tarjeta = pi_tarjeta
  ;

  po_cod_return:= '0';
  po_txt_return:= 'Exito';
  po_cvv := v_cvv;

exception
  when others then
    begin
      po_cod_return:= '1';
      po_txt_return:= 'Error';
    end;
end;

end PKG_CABAL_CRM;
/
