create or replace package PKG_CABAL_CRM is

  -- Author  : OOJEDA
  -- Created : 05/07/2021 14:09:07
  -- Purpose : Almanenar las fuentes relacionadas a las funcionalidades del CRM
  
-- ================================================================================== --
-- Autor: Lic. Orlando Ojeda
-- Fecha: 05/07/2021
-- Proposito: Obtener el numero de CVV de un TC
-- ================================================================================== --
procedure sp_get_cvv_tarjeta(pi_tarjeta in  varchar2,
                             pi_usuario in  varchar2,
                             pi_motivo  in  varchar2,
                             po_cod_return  out varchar2,
                             po_txt_return  out varchar2,
                             po_cvv     out varchar2); 

-- ================================================================================== --
-- Autor: Lic. Edgar Rojas
-- Fecha: 28/07/2021
-- Proposito: Listar datos bsicos de usuarios Dimo/Cabal
-- ================================================================================== --
PROCEDURE sp_get_datos_basicos_dimo(CP_DOCUMENTO   IN VARCHAR2
                                   ,CP_USUARIO     IN VARCHAR2
                                   ,NP_RESULTADO   OUT NUMBER
                                   ,CP_MOTIVO      OUT VARCHAR2
                                   ,PO_CUR_RETORNO OUT SYS_REFCURSOR);
  
end PKG_CABAL_CRM;
/
create or replace package body PKG_CABAL_CRM is
 -- Var de Log
 v_clog_tipo_dato  varchar2(50) := 'PKG_CABAL_CRM';

-- ================================================================================== --
-- Autor: Lic. Orlando Ojeda
-- Fecha: 05/07/2021
-- Proposito: Registrar en el CEIBO_LOG un registro relacionado al CRM
-- ================================================================================== --
procedure sp_registrar_ceibo_log(PI_DESCRIPCION IN VARCHAR2, 
                                 PI_DETALLE     IN VARCHAR2,
                                 PI_USUARIO     IN VARCHAR2 ) as
begin
  CREDITOPY.PKG_UTILES.PR_CEIBO_LOG(v_clog_tipo_dato,            --MAX 50
                                    SUBSTR(PI_DESCRIPCION,1,15), --MAX 15 CARACTERES (OjO)
                                    SUBSTR(PI_DETALLE,1,2048),
                                    SYSDATE,
                                    PI_USUARIO);                                
end;


-- ================================================================================== --
-- Autor: Lic. Orlando Ojeda
-- Fecha: 05/07/2021
-- Proposito: Obtener el numero de CVV de un TC
-- ================================================================================== --
procedure sp_get_cvv_tarjeta(pi_tarjeta in  varchar2,
                             pi_usuario in  varchar2,
                             pi_motivo  in  varchar2,
                             po_cod_return  out varchar2,
                             po_txt_return  out varchar2,
                             po_cvv     out varchar2) as
  v_cvv varchar2(100);
  
  -- Convierte todos los parametros de entrada del SP a una cadena de texto
  function f_i_parametros_in_toString return varchar2 as
  begin
    return 'pi_tarjeta: ' || pi_tarjeta || ';' ||
           'pi_usuario: ' || pi_usuario || ';' ||
           'pi_motivo: ' || pi_motivo || ';'
           ;
  end;
 
  
begin

  sp_registrar_ceibo_log(PI_DESCRIPCION => 'consultaCVV', -- MAX 15
                         PI_DETALLE     => 'Consulta Datos CVV. Parametros: [' || f_i_parametros_in_toString || ']',
                         PI_USUARIO     => pi_usuario);

  BEGIN PCUTILES.GET_PAN_CRIPTOKEY; END;
  
  select CS.GET_CVC(CEIBO_UTILES.FN_GET_EMISOR_PROCESADOR(T.EMISOR),T.TARJETA,T.FECHA_VIGENCIA,2) cvv
         into v_cvv
  from tarjetas t
  where 1=1
  and   t.tarjeta = pi_tarjeta
  ;
  
  po_cod_return:= '0';
  po_txt_return:= 'Exito';
  po_cvv := v_cvv;
  
exception
  when others then
    begin
      po_cod_return:= '1';
      po_txt_return:= 'Error';
    end;
end;

-- ================================================================================== --
-- Autor: Lic. Edgar Rojas
-- Fecha: 28/07/2021
-- Proposito: Listar datos bsicos de usuarios Dimo/Cabal       
              
/*
  Algoritmo: 
             En base al Documento lista todas las cuentas asociadas al documento.
             Pueden o no existir Cuentas.
             Obtiene los datos y/o servicios referentes al Email:
               1 Email
               2 Codigo de Envio de Extractos por Email
               3 Descripcion del Codigo de Envio de Extractos por Email
             Obtiene los datos y/o servicios referentes al Celular:
               1 Celular
               2 Codigo de Notificaciones por SMS
               3 Descripcion del Codigo de Notificaciones por SMS
             Realiza la Consulta Basica.
  Manejo de Errores:
    En caso de error, Siempre el procedimiento se completa y retorna ciertos valores:
      El Resultado es 1.
      El Motivo de error tiene un mensaje para identificar en que paso dio el error.
      El cursor es nulo.   
    Antes de ejecutar cada paso consigna el respectivo Motivo de error en la variable CP_MOTIVO.
    Si se da un error en la excepcion se registra en la bitacora y se retorna el Resultado con valor 1 y 
    el Motivo del error para identificar en que punto se dio el error.
    En la bitacora se detalla el error de base de datos.
 */            
-- ================================================================================== --
PROCEDURE sp_get_datos_basicos_dimo(CP_DOCUMENTO   IN VARCHAR2
                                   ,CP_USUARIO     IN VARCHAR2
                                   ,NP_RESULTADO   OUT NUMBER
                                   ,CP_MOTIVO      OUT VARCHAR2
                                   ,PO_CUR_RETORNO OUT SYS_REFCURSOR)
AS
  VC_DATOS_EMAIL   VARCHAR2(512);
  VC_EMAIL         DIRECCIONES.CALLE%TYPE;
  VC_FLAG          CHAR(1);
  VC_FLAG_DESC     VARCHAR2(32);
  VC_DATOS_CELULAR VARCHAR2(512);
  VC_CELULAR       DIRECCIONES.CALLE%TYPE;
  VC_SMS_FLAG      CHAR(1);
  VC_SMS_FLAG_DESC VARCHAR2(32);
  VR_CUENTA        CUENTAS%ROWTYPE;
  --Colleccion para almacenar todas las cuentas y retornar como cursor.
  --Tipo de Registro
  VREC_DATO_BASICO DATO_BASICO;
  
  VTAB_DATOS_BASICOS CREDITOPY.Tab_DATOS_BASICOS := Tab_DATOS_BASICOS();
  VI_INDICE BINARY_INTEGER;
  -- Convierte todos los parametros de entrada del SP a una cadena de texto
  function f_i_parametros_in_toString return varchar2 as
  begin
    return 'CP_DOCUMENTO: ' || CP_DOCUMENTO || ';' ||
           'CP_USUARIO: ' || CP_USUARIO || ';' ||
           'CP_MOTIVO: ' || CP_MOTIVO || ';'
           ;
  end;  
BEGIN
  --Iteramos por todas las Cuentas del Documento.
  CP_MOTIVO    := 'Error al buscar las cuentas para el documento '||CP_DOCUMENTO;
  VI_INDICE := 0;
  FOR C IN (SELECT *
            FROM CUENTAS A
            WHERE A.TIPO_DE_DOCUMENTO = 1
              AND A.DOCUMENTO LIKE '%'||CP_DOCUMENTO
  )LOOP
    --Obtenemos los datos de la Cuenta.
    VR_CUENTA := C;
    
    --Obtener datos de Email
    CP_MOTIVO      := 'Error al buscar datos del Email para la Cuenta '||C.NUMERO_CUENTA;
    VC_DATOS_EMAIL := FC_GET_EMAIL_CUENTA@OLPY(VR_CUENTA.EMISOR,VR_CUENTA.SUCURSAL_EMISOR,VR_CUENTA.NUMERO_CUENTA,VR_CUENTA.DOCUMENTO);   
    FOR R IN (SELECT ROWNUM RID,REGEXP_SUBSTR(VC_DATOS_EMAIL,'[^|]+', 1, LEVEL) DATO
                    FROM DUAL
                    CONNECT BY REGEXP_SUBSTR(VC_DATOS_EMAIL, '[^|]+', 1, LEVEL) IS NOT NULL
    )LOOP
      CASE R.RID
        WHEN 1 THEN
          CP_MOTIVO      := 'Error al leer el Email para la Cuenta '||VR_CUENTA.NUMERO_CUENTA||' El dato es '||R.DATO;
          VC_EMAIL := R.DATO;
        WHEN 2 THEN
          CP_MOTIVO      := 'Error al leer el Flag de Envio (SOLO 1 CARACTER) de Email para la Cuenta '||VR_CUENTA.NUMERO_CUENTA||' El dato es '||R.DATO;
          VC_FLAG := R.DATO;
        WHEN 3 THEN
          CP_MOTIVO      := 'Error al leer la descripcion del Flag de Envio de Email para la Cuenta '||VR_CUENTA.NUMERO_CUENTA||' El dato es '||R.DATO;
          VC_FLAG_DESC := R.DATO;
      END CASE;
    END LOOP;
        
    --Obtener datos de Celular
    CP_MOTIVO        := 'Error al buscar datos del Celular para la Cuenta '||VR_CUENTA.NUMERO_CUENTA;
    VC_DATOS_CELULAR := FC_GET_CELULAR_CUENTA@OLPY(VR_CUENTA.EMISOR,VR_CUENTA.SUCURSAL_EMISOR,VR_CUENTA.NUMERO_CUENTA,VR_CUENTA.DOCUMENTO);
    
    FOR R IN (SELECT ROWNUM RID,REGEXP_SUBSTR(VC_DATOS_CELULAR,'[^|]+', 1, LEVEL) DATO
                    FROM DUAL
                    CONNECT BY REGEXP_SUBSTR(VC_DATOS_CELULAR, '[^|]+', 1, LEVEL) IS NOT NULL
    )LOOP
      CASE R.RID
        WHEN 1 THEN
          CP_MOTIVO  := 'Error al leer el Celular para la Cuenta '||VR_CUENTA.NUMERO_CUENTA||' El dato es '||R.DATO;
          VC_CELULAR := R.DATO;
        WHEN 2 THEN
          CP_MOTIVO   := 'Error al leer el Flag de Notificaciones SMS (SOLO 1 CARACTER) del celular para la Cuenta '||VR_CUENTA.NUMERO_CUENTA||' El dato es '||R.DATO;
          VC_SMS_FLAG := R.DATO;
        WHEN 3 THEN
          CP_MOTIVO        := 'Error al leer la descripcion del Flag de Notificaciones SMS del celular para la Cuenta '||VR_CUENTA.NUMERO_CUENTA||' El dato es '||R.DATO;
          VC_SMS_FLAG_DESC := R.DATO;
      END CASE;
    END LOOP;
    
    CP_MOTIVO := 'Error al consultar datos basicos para la Cuenta '||VR_CUENTA.NUMERO_CUENTA;
    
    --Agregar esta Cuenta en la coleccion.
    FOR R IN (
                SELECT CU.EMISOR,CU.NUMERO_CUENTA,NOMBRES, APELLIDOS, 
                       CP_DOCUMENTO DOCUMENTO, PERSONAS2.TIPO_DE_DOCUMENTO AS TIPO_DE_DOCUMENTO,
                       ' ' AS FAX, 
                       VC_EMAIL EMAIL,VC_FLAG EMAIL_FLAG,VC_FLAG_DESC EMAIL_FLAG_DESCRIPCION
                       , VC_CELULAR CELULAR,VC_SMS_FLAG SMS_FLAG,VC_SMS_FLAG_DESC SMS_FLAG_DESCRIPCION
                       , CALLE, TIENE_EXTENSION, NUMERO_PUERTA, APARTAMENTO,
                       DIRECCIONES.CODIGO_POSTAL AS CODIGO_POSTAL, CREDITOPY.DIRECCIONES.TELEFONO, DIRECCIONES.TIPO_DE_DIRECCION AS TIPO_DE_DIRECCION,
                       TIPOS_DIRECCIONES.DESCRIPCION AS DESC_DIRECCION, DEPARTAMENTOS1.DESCRIPCION AS DEPARTAMENTODESC,
                       CIUDADES.DESCRIPCION AS CIUDADDESC, TIPOS_DOCUMENTOS.DESCRIPCION AS DOCDESC,
                       GRUPOS_AFINIDAD.GRUPO_AFINIDAD AS CODGRAFINIDAD, GRUPOS_AFINIDAD.DESCRIPCION AS DESCAFINIDAD,
                       EMPRESAS.RAZON_SOCIAL AS DESCEMPRESA, CU.NUMERO_SOCIO_LEGAJO AS SOCIO, CODIGOS_CORRESPONDENCIA.DESCRIPCION AS CODIGO_DE_CORRESPONDENCIA,
                       C.DESCRIPCION CARTERA,P.DESCRIPCION CAPTADOR
                    FROM CREDITOPY.CUENTAS CU, DEBCREDPY.CIUDADES, CREDITOPY.DIRECCIONES, DEBCREDPY.TIPOS_DIRECCIONES, DEBCREDPY.EMPRESAS,
                           DEBCREDPY.PERSONAS PERSONAS2, DEBCREDPY.TIPOS_DOCUMENTOS, CREDITOPY.GRUPOS_AFINIDAD,
                           DEBCREDPY.DEPARTAMENTOS DEPARTAMENTOS1, CREDITOPY.CODIGOS_CORRESPONDENCIA CODIGOS_CORRESPONDENCIA,
                           DEBCREDPY.CARTERAS C,DEBCREDPY.CAPTADORES P,CREDITOPY.TARJETAS TJ
                    WHERE CU.PRODUCTO = 1
                      AND CU.TIPO_DE_DOCUMENTO = PERSONAS2.TIPO_DE_DOCUMENTO
                      AND CU.DOCUMENTO = PERSONAS2.DOCUMENTO
                      AND CU.TIPO_DE_DOCUMENTO = TIPOS_DOCUMENTOS.TIPO_DE_DOCUMENTO
                      AND CU.NUMERO_CUENTA = DIRECCIONES.NUMERO_CUENTA
                      AND DIRECCIONES.DEPARTAMENTO = DEPARTAMENTOS1.DEPARTAMENTO
                      AND DIRECCIONES.CIUDAD = CIUDADES.CIUDAD
                      AND DIRECCIONES.TIPO_DE_DIRECCION = 1
                      AND DIRECCIONES.TIPO_DE_DIRECCION = TIPOS_DIRECCIONES.TIPO_DE_DIRECCION
                      AND DEPARTAMENTOS1.DEPARTAMENTO = CIUDADES.DEPARTAMENTO
                      AND CU.NUMERO_EMPRESA = EMPRESAS.NUMERO_EMPRESA (+)
                      AND CU.GRUPO_AFINIDAD = GRUPOS_AFINIDAD.GRUPO_AFINIDAD
                      AND CU.EMISOR = GRUPOS_AFINIDAD.EMISOR
                      --
                      AND CU.EMISOR = VR_CUENTA.EMISOR
                      AND CU.EMISOR = CODIGOS_CORRESPONDENCIA.EMISOR
                      AND CU.CODIGO_DE_CORRESPONDENCIA = CODIGOS_CORRESPONDENCIA.CODIGO
                      AND C.EMISOR = CU.EMISOR
                      AND C.CARTERA = CU.CARTERA
                      AND TJ.NUMERO_CUENTA = CU.NUMERO_CUENTA
                      AND TJ.TARJETA = DEBCREDPY.TARJETA_VIGENTE(TJ.NUMERO_CUENTA)
                      AND P.EMISOR(+) = TJ.EMISOR
                      AND P.CODIGO_CAPTADOR(+) = TJ.CODIGO_CAPTADOR
                      --
                      AND CU.NUMERO_CUENTA = VR_CUENTA.NUMERO_CUENTA    
    )LOOP
      --Se incrementa el indice para expandir la Coleccion.
      VI_INDICE := VI_INDICE + 1;
      --Se extiende la Coleccion.
      VTAB_DATOS_BASICOS.EXTEND;
      --Se asignan los datos al registo de dato basico Dimo.
      VREC_DATO_BASICO := DATO_BASICO( R.EMISOR
                                      ,R.NUMERO_CUENTA
                                      ,R.NOMBRES 
                                      ,R.APELLIDOS 
                                      ,R.DOCUMENTO 
                                      ,R.TIPO_DE_DOCUMENTO 
                                      ,R.FAX 
                                      ,R.EMAIL 
                                      ,R.EMAIL_FLAG 
                                      ,R.EMAIL_FLAG_DESCRIPCION 
                                      ,R.CELULAR 
                                      ,R.SMS_FLAG 
                                      ,R.SMS_FLAG_DESCRIPCION 
                                      ,R.CALLE 
                                      ,R.TIENE_EXTENSION 
                                      ,R.NUMERO_PUERTA   
                                      ,R.APARTAMENTO     
                                      ,R.CODIGO_POSTAL   
                                      ,R.TELEFONO        
                                      ,R.TIPO_DE_DIRECCION 
                                      ,R.DESC_DIRECCION 
                                      ,R.DEPARTAMENTODESC 
                                      ,R.CIUDADDESC 
                                      ,R.DOCDESC 
                                      ,R.CODGRAFINIDAD 
                                      ,R.DESCAFINIDAD 
                                      ,R.DESCEMPRESA 
                                      ,R.SOCIO 
                                      ,R.CODIGO_DE_CORRESPONDENCIA 
                                      ,R.CARTERA 
                                      ,R.CAPTADOR 
                                      );
      --Se agrega el nuevo registro a la coleccion.
      VTAB_DATOS_BASICOS(VI_INDICE) := VREC_DATO_BASICO;
    END LOOP;      
  END LOOP;
  --Se retorna la Coleccion como cursor.
  OPEN PO_CUR_RETORNO FOR
        SELECT A.*
          FROM TABLE (VTAB_DATOS_BASICOS) A; 
      
  --Finalmente retornamos el resultado.
  NP_RESULTADO := 0;
  CP_MOTIVO    := 'Proceso ejecutado correctamente.';
EXCEPTION
  WHEN OTHERS THEN
    NP_RESULTADO := 1;
    SP_REGISTRAR_CEIBO_LOG(PI_DESCRIPCION => 'BASICOS_DIMO' -- MAX 15
                          ,PI_DETALLE     => 'Consulta Datos Basicos DIMO. Parametros: [' || f_i_parametros_in_toString || '] Error:'||SQLERRM
                          ,PI_USUARIO     => CP_USUARIO);
END; 

end PKG_CABAL_CRM;
/
